var bdAccountStore;
//是否正在签到
var isSigning=false;
Ext.onReady( function() {
	//百度账号
	var formItem=Ext.create("as.Form.BdAccount");
	var listType;
	if(isSystemAdmin=="1"){
		listType="ysj.panel.list.ListMngQueryForm";
	}else{
		listType="ysj.panel.list.ListMng";
	}
	
	var listManagerPanel=Ext.create(listType,{
		addUrl:"as/BdAccount/saveBdAccount.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,//添加路径
		addFormItems:formItem.getAddFormItems(),//添加表单项
		afterAddFormHandler:function(){
			regreshComboList();
		},
		
		deleteUrl:"as/BdAccount/deleteBdAccounts.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,//删除路径
		afterDeleteFormHandler:function(){
			regreshComboList();
		},
		
		updateUrl:"as/BdAccount/updateBdAccount.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,//修改路径
		updateFormItems:formItem.getUpdateFormItems(),//修改表单项
		afterUpdateFormHandler:function(){
			regreshComboList();
		},
		
		detailModel:as.Model.BdAccount,//详细信息模型
        detailFormItems:formItem.getDetailFormItems(),//详细表单项
        
        queryFormItems:formItem.getQueryFormItems(),//查询表单项
		queryFormHeight:100,//查询表单高度
		
        gridTitle:"百度账号<span style='color:#44f83f;float:right;font-size:18px;'>温馨提示：系统将于每天凌晨1点对启用的账号自动签到</span>",
		gridColumns:[
		    { text: 'ID',  dataIndex: 'id',hidden:true },
	        { text: '账号',  dataIndex: 'username',flex:4},
	        { text: '启用', dataIndex: 'autoSign',flex:1,renderer:formItem.autoSignRender}],//数据表格列
	    //数据列表Store
        gridStore:Ext.create("as.Store.BdAccountList"),
        
    	customBarButtons:[{
			index:3,
			button:cb.getRightSmallButtonAtBar({
				text:"启用",
				clickHandler:function(){
					var id=getBdAccountId();
					if(Ext.isEmpty(id)){
						cw.warn({
							text:"请选择一条要启用的账号！"
						});
						return;
					}
					ca.request({
						url:"as/BdAccount/active.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,
						params:{id:id},
						success:function(data){
							//不需要验证码
							if(!data.checkCodePath){
								cw.success();
								refreshBdAccount();
								return;
							}
							//加载验证码
							loadCheckCode(data.checkCodePath);
							//显示验证码输入窗口
							checkcodeWind.show();
						},
						failure:function(errors){
							cw.fail({msg:co.stringObject(errors,":","<br/>")});
						}
					});
				}
			})
		},{
			index:4,
			button:cb.getWrongSmallButtonAtBar({
				text:"禁用",
				clickHandler:function(){
					var id=getBdAccountId();
					if(Ext.isEmpty(id)){
						cw.warn({
							text:"请选择一条要禁用的账号！"
						});
						return;
					}
					ca.request({
						url:"as/BdAccount/inactive.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,
						params:{id:id},
						success:function(data){
							cw.success();
							refreshBdAccount();
						}
					});
				}
			})
		}],
				
        //添加/修改/详细窗口宽度
    	windowWidth:400,
    	//添加/修改/详细窗口高度
    	windowHeight:230,
    	
		border:false,
		
		width:"100%",
		
		flex:2
	});
	
	//验证码
	var checkcodePanel=Ext.create('Ext.form.Panel',{
		labelWidth : 100,
		labelAlign : GLOBAL_CNS_LABEL_ALIGN,
		autoScroll:true,
		border:false,
		contentEl:"checkcodeInputForm"
	});
	var checkcodeFormPanel=Ext.create('Ext.form.Panel',{
		autoScroll:true,
		border:false,
		contentEl:"checkcodeInputForm",
		style:"padding-top:30px;",
		items:[
			{
		        labelWidth : 90,
				labelAlign : "right",
				xtype : 'textfield',
				fieldLabel : '验证码',
				name : 'checkCode'
			}
		]
    });
	var panel=Ext.create('Ext.form.Panel',{
		border:false,
		items:[checkcodePanel,checkcodeFormPanel]
	});
	var checkcodeWind=cw.getUpdateWindow({
		windowWidth:400,
		windowHeight:230,
		title:"<img src='images/sys/big/edit.png' width='20' height='20' />输入验证码",
		formPanel:panel,
		windowPanel:panel,
		handler:function(){
			//Form表单验证
			var form=checkcodeFormPanel.getForm();
			if(!form.isValid()){
				return;
			}
			var data=form.getValues();
			data.id=getBdAccountId();
			//提交表单
			form.submit({
				url:"as/BdAccount/activeWithCheckcode.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,
				params:data,
				method:"POST",
				success:function(f,action){
					//账号或密码错误
					if(action.result.data){
						cw.fail(action.result.data);
						checkcodeWind.hide();
						return;
					}				
					cw.success();
					checkcodeWind.hide();
					refreshBdAccount();
				},
				failure:function(a,b){
					cf.submitFailureHander(a,b);
					//重新获取验证码
					loadCheckCode(b.result.errors.checkCodePath);
				}
			});
		}
	});
	
	/**
	 * 获取选中的账号ID
	 */
	function getBdAccountId(){
		//获取选中的数据
		var selModel;
		if(isSystemAdmin=="1"){
			selModel=listManagerPanel.listPanel.listPanel.getSelectionModel();
		}else{
			selModel=listManagerPanel.listPanel.getSelectionModel();
		}
		 
		if(!selModel.hasSelection()){
			return;
		}
		var selected = selModel.getSelection();
		if(selected.length>1){
			return;
		}
		return selected[0].get("id");
	}
	
	/**
	 * 加载验证码
	 */
	function loadCheckCode(checkCodePath){
		Ext.get("checkcode").set({"src":checkCodePath});
	}
	
	
	function regreshComboList(){
		bdAccountStore.load();
	}
	
	/**
	 * 刷新百度账号
	 * 1、账号列表
	 * 2、账号下拉框
	 */
	function refreshBdAccount(){
		regreshComboList();
		listManagerPanel.query();
	}
	
	//贴吧
	var bdTieBaForm=Ext.create("as.Form.BdTieBa");
	//账号下拉列表
	bdAccountStore = Ext.create('Ext.data.Store', {
	    fields: ['id', 'username'],
	    proxy: { 
			//异步获取数据，这里的URL可以改为任何动态页面，只要返回JSON数据即可        
			type: 'ajax', 
			url: "as/BdAccount/getBdAccountsByCondsNoPage.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,
			actionMethods: {
				read: 'POST'//读取数据的请求方式
			},
			reader: { 
				type: 'json', 
				root: "data"
			} 
		}
	});
	var companyList={
		id:'companyList',
		xtype : 'comboboxrefresh',
		fieldLabel : '切换账号',
		labelStyle:"color:red;font-weight:bold;",
		labelAlign : "right",
		labelWidth:90,
		displayField: 'username',
	    valueField: 'id',
	    store:bdAccountStore,
	    queryParam:"username",
	    listeners:{
	    	select:function( combo, records, eOpts){
	    		if(tieBaPanel.listPanel.getStore().isLoading()){
	    			cw.warn({
						text:"正在同步数据，请稍后操作！"
					});
	    			
					return;
				}
	    		tieBaPanel.query({id:records[0].get("id")});
	    	},
	    	beforequery:function(){
	    		var c=Ext.getCmp("adminId");
	    		if(!Ext.isEmpty(c)){
	    			bdAccountStore.proxy.extraParams.adminId=c.getValue();
	    		}
			}
	    }
	}
	//贴吧详细信息窗口
	var tieBaDetailPanel=Ext.create('Ext.form.Panel',{
		autoScroll:true,
		border:false,
		items: bdTieBaForm.getDetailFormItems()
    });
	var tieBaDetailWind=cw.getDetailWindow({
		windowWidth:500,
		windowHeight:330,
		title:"<img src='images/sys/big/search.png' width='20' height='20' />详细信息,与百度贴吧有"+QRY_BAIDU_TB_DETAIL_FCY+"分种延时",
		formPanel:tieBaDetailPanel,
		windowPanel:tieBaDetailPanel
	});
	var tieBaPanel=Ext.create("ysj.panel.list.ListMng",{
		
		barButtons:[],
		
		//自定义工具栏按钮
		customBarButtons:[{
			index:1,
			button:companyList
		},{
			index:2,
			button:cb.getCaculateSmallButtonAtBar({
				text:"一键签到",
				clickHandler:function(){
					var id=Ext.getCmp("companyList").getValue();
					if(Ext.isEmpty(id)){
						cw.warn({
							text:"请选左边的账号！"
						});
						return;
					}
					if(tieBaPanel.listPanel.getStore().isLoading()){
						cw.warn({
							text:"正在同步数据，请稍后操作！"
						});
						return;
					}
					if(isSigning){
						cw.warn({
							text:"正在签到，请稍后操作！"
						});
						return;
					}
					isSigning=true;
					var store=tieBaPanel.listPanel.getStore();
					var count=0;
					//遍历全部贴吧
					store.each(function(r){
						r.set("todaySigned","4");
					});
					var signConfig = {
						run: function(){
							if(count<store.getCount()){
								var r=store.getAt(count);
								ca.request({
									url:"as/BdAccount/signBdTieBa.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,
									params:{bdAccountId:id,bdTieBaId:r.get("id")},
									success:function(data){
										//cw.success();
										r.set("todaySigned",data.signResult);
										r.set("exp",data.exp);
										++count;
										if(count<store.getCount()){
											r=store.getAt(count);
											r.set("todaySigned","3 正在努力签到中，O(∩_∩)O~");
										}
									},
									failure:function(errors){
										++count;
										tieBaPanel.listPanel.setLoading(false);
										cw.fail({msg:co.stringObject(errors,":","<br/>")});
									}
								});
								
							}else{
								isSigning=false;
//								tieBaPanel.listPanel.setLoading(false);
								Ext.TaskManager.stopAll();
							}
						},
				        interval: 5000 //1000=1 second
					}
					Ext.TaskManager.start(signConfig);
					if(store.getCount()>0){
						var r=store.getAt(0);
						r.set("todaySigned","3 正在努力签到中，O(∩_∩)O~");
					}
				}
			})
		},{
			index:3,
			button:cb.getRefreshSmallButtonAtBar({
				text:"刷新",
				clickHandler:function(){
					var id=Ext.getCmp("companyList").getValue();
					if(Ext.isEmpty(id)){
						cw.warn({
							text:"请选左边的账号！"
						});
						return;
					}
					if(tieBaPanel.listPanel.getStore().isLoading()){
						cw.warn({
							text:"正在同步数据，请稍后操作！"
						});
						return;
					}
					if(isSigning){
						cw.warn({
							text:"正在签到，请稍后操作！"
						});
						return;
					}
					tieBaPanel.query({id:id});
				}
			})
		},{
			index:4,
			button:cb.getDetailSmallButtonAtBar({
				text:"详细",
				clickHandler:function(){
					//账号ID
					var id=Ext.getCmp("companyList").getValue();
					if(Ext.isEmpty(id)){
						cw.warn({
							text:"请选一个贴吧！"
						});
						return;
					}
					//贴吧URL
		    		var ids=tieBaPanel.getSelectedIds();
		    		if(ids.length!=1){
		    			cw.warn({
		    				text:"请选一个贴吧！"
		    			});
		    			return;
		    		}
					if(tieBaPanel.listPanel.getStore().isLoading()){
						cw.warn({
							text:"正在同步数据，请稍后操作！"
						});
						return;
					}
					if(isSigning){
						cw.warn({
							text:"正在签到，请稍后操作！"
						});
						return;
					}
					tieBaPanel.listPanel.setLoading(true);
					ca.request({
						url:"as/BdAccount/getBdTieBa.do?"+GLOBAL_VIEW_FRAMEWORK_TYPE_EXTJS4,
						params:{bdAccountId:id,tieBaId:ids},
						success:function(data){
							tieBaDetailWind.show();
							Ext.getCmp("name").setValue(data.name);
							if(!Ext.isEmpty(data.exp)){
								Ext.getCmp("exp").setValue(data.exp);
							}
							if(!Ext.isEmpty(data.level)){
								Ext.getCmp("level").setValue(data.level+"级 "+data.levelTitle);
							}
							if(data.todaySigned=="1"){
								Ext.getCmp("todaySigned").setValue("是");
							}else if(data.todaySigned=="2"){
								Ext.getCmp("todaySigned").setValue("否");
							}else if(data.todaySigned=="3"){
								Ext.getCmp("todaySigned").setValue("本吧不能签到");
							}
							if(!Ext.isEmpty(data.keepSign)){
								Ext.getCmp("keepSign").setValue(data.keepSign);
							}else{
								Ext.getCmp("keepSign").setValue("无");
							}
							if(!Ext.isEmpty(data.totalSign)){
								Ext.getCmp("totalSign").setValue(data.totalSign);
							}else{
								Ext.getCmp("totalSign").setValue("无");
							}
							tieBaPanel.listPanel.setLoading(false);
						},
						failure:function(errors){
							tieBaPanel.listPanel.setLoading(false);
							cw.fail({msg:co.stringObject(errors,":","<br/>")});
						}
					});
				}
			})
		}],
		
		gridTitle:"我喜欢的贴吧,与服务器有"+QRY_BAIDU_TB_LIST_FCY+"分种延时",
    	gridPage:false,//不翻页
		gridColumns:[
		    { text: 'ID',  dataIndex: 'id',hidden:true },
	        { text: '贴吧名称',  dataIndex: 'name',width:150 ,flex:4,sortable:false},
	        { text: '经验', dataIndex: 'exp',width:150,flex:1,sortable:false,renderer:bdTieBaForm.expRender},
	        { text: '等级名称', dataIndex: 'level',width:150,flex:2,sortable:false,renderer:bdTieBaForm.levelRender},
	        { text: '签到', dataIndex: 'todaySigned',width:150,flex:3,sortable:false,renderer:bdTieBaForm.todaySignedRender}],//数据表格列
	    //数据列表Store
        gridStore:Ext.create("as.Store.BdTieBaList"),
        //是否显示脏数据标记
    	markDirty:false,
        
        //添加/修改/详细窗口宽度
    	windowWidth:400,
    	//添加/修改/详细窗口高度
    	windowHeight:230,
	    
		border:false,
		
		width:"100%",
		
		flex:3
	});
	Ext.create("Ext.container.Viewport",{
		layout: {
            type:'vbox'
        },
		items:[listManagerPanel,tieBaPanel]
	});
	Ext.get('loading-mask').fadeOut({remove:true});
	listManagerPanel.query();
});